/**
 * 
 */
/**
 * @author Janet Lopez
 *
 */
package gov.va.genisis2.common.enums;

import static org.junit.Assert.assertTrue;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.AbstractMockMvcTests;

/**
 * The Class CommonEnumTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class CommonEnumTest.
 * 
 *          Description: In this CommonEnumTest Class which extends the abstract
 *          class, AbstractMockMvcTests, junit tests are defined.
 */

public class CommonEnumTest extends AbstractMockMvcTests {
	
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(CommonEnumTest.class);

	/**
	 * Test common enum.
	 */
	@Test
	public void testCommonEnum() {

		LOGGER.info("**********Junit Test Common Enum**********");

		assertTrue(CommonEnum.NO_RECORD_FOUND.getText().toLowerCase().compareTo("No records found.".toLowerCase()) == 0);
		assertTrue(CommonEnum.SPACE.getText().compareToIgnoreCase(" ") == 0);
		assertTrue(CommonEnum.UNABLE_TO_CREATE_REQUEST.getText().toLowerCase().compareTo("Unable to create Request. Business process failed to start.".toLowerCase()) == 0);
		assertTrue(CommonEnum.UNABLE_TO_UPDATE_STUDY_APPROVAL.getText().toLowerCase().compareTo("Unable to update Study Approval".toLowerCase()) == 0);
		assertTrue(CommonEnum.STATUS_DESC.getText().toLowerCase().compareTo("statusDescription".toLowerCase()) == 0);

		LOGGER.info("**********End of Junit Test Common Enum**********");
	}

}
